﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;
using MCSShared;


namespace VA.TMP.CRM.Facility_Approval
{
    class FacilityApprovalUpdatePostStageRunner : PluginRunner
    {
        public FacilityApprovalUpdatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        public override string McsSettingsDebugField
        {
            get { return "cvt_facilityapprovalplugin"; }
        }
        public override void Execute()
        {
            if (PrimaryEntity.LogicalName != cvt_facilityapproval.EntityLogicalName)
            {
                return;
            }
            var thisRecord = PrimaryEntity.ToEntity<cvt_facilityapproval>();
            //Check 4x Status
            CheckApprovalStatus(thisRecord);


        }

        internal void CheckApprovalStatus(cvt_facilityapproval thisSave)
        {
            using (var srv = new Xrm(OrganizationService))
            {
                var facilityApprovalRecord = srv.cvt_facilityapprovalSet.FirstOrDefault(FA => FA.Id == thisSave.Id);

                if (facilityApprovalRecord == null)
                {
                    Logger.WriteToFile("FA approval record could not be found, exiting FA Approval Status check.");
                    return;
                }
                var anyDenied = false;
                var allApproved = false;
                var pendingCount = 0;
                bool isActive = false;




                if (facilityApprovalRecord != null)
                {
                    isActive = CheckRecordStatus((int)facilityApprovalRecord.statecode.Value);

                    var patCOS = facilityApprovalRecord.cvt_ApprovalStatusPatientCOS?.Value;
                    var proCOS = facilityApprovalRecord.cvt_ApprovalStatusProviderCOS?.Value;
                    var patSC = facilityApprovalRecord.cvt_ApprovalStatusPatientSC?.Value;
                    var proSC = facilityApprovalRecord.cvt_ApprovalStatusProviderSC?.Value;
                    var patFTC = facilityApprovalRecord.cvt_ApprovalStatusPatientFTC?.Value;
                    var proFTC = facilityApprovalRecord.cvt_ApprovalStatusProviderFTC?.Value;

                    //check for non-approved/non-denied fields
                    if (facilityApprovalRecord.cvt_ApprovalStatusPatientCOS?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }
                    if (facilityApprovalRecord.cvt_ApprovalStatusProviderCOS?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }
                    if (facilityApprovalRecord.cvt_ApprovalStatusPatientSC?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }
                    if (facilityApprovalRecord.cvt_ApprovalStatusProviderSC?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }
                    if (facilityApprovalRecord.cvt_ApprovalStatusPatientFTC?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }
                    if (facilityApprovalRecord.cvt_ApprovalStatusProviderFTC?.Value == 917290000)
                    {
                        pendingCount += 1;
                    }


                    //If Hub, so check hub director and pat/pro COS
                    if (facilityApprovalRecord.cvt_hubfacility != null && facilityApprovalRecord.cvt_hubfacility.Id != Guid.Empty)
                    {
                        var hubDirector = facilityApprovalRecord.cvt_ApprovalStatusHubDirector?.Value;

                        allApproved = CheckApprovedStatus(hubDirector, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(patCOS, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(proCOS, anyDenied, allApproved, out anyDenied);
                    }
                    //If not hub, so check both pat and prov SC/COS
                    // also check pat and prov FTC
                    else
                    {
                        allApproved = CheckApprovedStatus(patSC, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(patCOS, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(patFTC, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(proSC, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(proCOS, anyDenied, allApproved, out anyDenied);
                        allApproved = CheckApprovedStatus(proFTC, anyDenied, allApproved, out anyDenied);
                    }
                    //Update the status of this record to Denied
                    if (anyDenied == true && facilityApprovalRecord.statuscode.Value != (int)cvt_facilityapproval_statuscode.Denied)
                    {
                        Logger.WriteDebugMessage("anyDenied = true and status is not denied, atemmpting to change to denied.");
                        UpdateFacilityApprovalStatus(facilityApprovalRecord.Id, (int)cvt_facilityapproval_statuscode.Denied);

                        //entry point to Build Service at 'EntryFromFacilityApproval' for new DENIED (was previously Approved) FA
                        Logger.WriteDebugMessage("Updating Service - FA: " + facilityApprovalRecord.cvt_name + " was previously Approved and is now Denied.");
                        CvtHelper.EntryFromFacilityApproval(facilityApprovalRecord, Logger, OrganizationService);

                    }
                    else if (anyDenied == true && facilityApprovalRecord.statuscode.Value == (int)cvt_facilityapproval_statuscode.Denied)
                    {
                        //Correct status
                        Logger.WriteDebugMessage("Should be Denied and is already Denied, don't change the status");
                    }
                    //Update the status of this record to Approved
                    else if (allApproved == true && facilityApprovalRecord.statuscode.Value != (int)cvt_facilityapproval_statuscode.Approved && pendingCount == 0)
                    {
                        Logger.WriteDebugMessage("allApproved = true and status is not approved, atemmpting to change to approved.");
                        UpdateFacilityApprovalStatus(facilityApprovalRecord.Id, (int)cvt_facilityapproval_statuscode.Approved);

                        //entry point to Build Service at 'EntryFromFacilityApproval' for new APPROVED FA
                        Logger.WriteDebugMessage("Updating Service - FA: " + facilityApprovalRecord.cvt_name + " is now Approved.");
                        CvtHelper.EntryFromFacilityApproval(facilityApprovalRecord, Logger, OrganizationService);

                        var schedulingPackageRecord = srv.cvt_resourcepackageSet.FirstOrDefault(SP => SP.Id == facilityApprovalRecord.cvt_resourcepackage.Id);

                        if (schedulingPackageRecord == null)
                        {
                            Logger.WriteToFile("SP record could not be found, exiting FA Approval Status check.");
                            return;
                        }

                        //create EntityReference
                        EntityReference erRecord = new EntityReference("cvt_facilityapproval", facilityApprovalRecord.Id);

                        if (facilityApprovalRecord.cvt_hubfacility != null)
                        {
                            //Send notification to TSA Notification Team
                            Email tsaNotification = new Email()
                            {
                                Subject = "TSAAPPROVED",
                                Description = facilityApprovalRecord.cvt_providerfacility.Name + " and " + facilityApprovalRecord.cvt_patientfacility.Name + " have now been approved by the Hub Director and the Patient and Provider Chiefs of Staff to conduct a hub interfacility " + schedulingPackageRecord.cvt_specialty.Name + ", " + schedulingPackageRecord.cvt_specialtysubtype.Name + " telehealth service.<br/><br>/To view the approvals and generate the Telehealth Service Agreement, please " + GetRecordLink(erRecord, OrganizationService, "click here.<br/><br/>"),
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, facilityApprovalRecord.Id)

                            };
                            //OrganizationService.Create(tsaNotification);
                        }
                        else
                        {
                            //Send notification to TSA Notification Team

                            if (schedulingPackageRecord.cvt_specialtysubtype != null) //there is a Specialty Subtype
                            {
                                Email tsaNotification = new Email()
                                {
                                    Subject = "TSAAPPROVED",
                                    Description = facilityApprovalRecord.cvt_providerfacility.Name + " and " + facilityApprovalRecord.cvt_patientfacility.Name + " have now been approved by Provider and Patient FTCs, Service Chiefs and Chiefs of Staff to conduct an interfacility " + schedulingPackageRecord.cvt_specialty.Name + ", " + schedulingPackageRecord.cvt_specialtysubtype.Name + " telehealth service.<br/><br/>To view the approvals and generate the Telehealth Service Agreement, please " + GetRecordLink(erRecord, OrganizationService, "click here.<br/><br/>"),
                                    RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, facilityApprovalRecord.Id)

                                };
                                OrganizationService.Create(tsaNotification);
                            }
                            else  //no specialty subtype
                            {
                                Email tsaNotification = new Email()
                                {
                                    Subject = "TSAAPPROVED",
                                    Description = facilityApprovalRecord.cvt_providerfacility.Name + " and " + facilityApprovalRecord.cvt_patientfacility.Name + " have now been approved by Provider and Patient FTCs, Service Chiefs and Chiefs of Staff to conduct an interfacility " + schedulingPackageRecord.cvt_specialty.Name + " telehealth service.<br/><br/>To view the approvals and generate the Telehealth Service Agreement, please " + GetRecordLink(erRecord, OrganizationService, "click here.<br/><br/>"),
                                    RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, facilityApprovalRecord.Id)

                                };
                                OrganizationService.Create(tsaNotification);
                            }


                        }
                    }
                    else if (allApproved == true && facilityApprovalRecord.statuscode.Value == (int)cvt_facilityapproval_statuscode.Approved)
                    {
                        //Correct status
                        Logger.WriteDebugMessage("Should be Approved and is already Approved, don't change the status");
                    }
                    else if (facilityApprovalRecord.statuscode.Value == (int)cvt_facilityapproval_statuscode.Pending)
                    {

                        //Check for just changed values (provider FTC Team)
                        var isProFTCChanged = thisSave.cvt_ApprovalStatusProviderFTC?.Value;
                        Logger.WriteDebugMessage("isProFTCChanged=" + isProFTCChanged);
                        if (isProFTCChanged != null && isProFTCChanged == (int)cvt_facilityapprovalstatus.Approve && proSC == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY)
                        {//Send email to PRO SC
                            Email proSCEmail = new Email()
                            {
                                Subject = "Service Chief Approval Requested",
                                Description = "Provider",
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, thisSave.Id)
                            };
                            OrganizationService.Create(proSCEmail);
                        }

                        //Check for just changed values (patient FTC Team)
                        var isPatFTCChanged = thisSave.cvt_ApprovalStatusPatientFTC?.Value;
                        Logger.WriteDebugMessage("isPatFTCChanged=" + isPatFTCChanged);
                        if (isPatFTCChanged != null && isPatFTCChanged == (int)cvt_facilityapprovalstatus.Approve && patSC == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY)
                        {//Send email to PAT SC
                            Email patSCEmail = new Email()
                            {
                                Subject = "Service Chief Approval Requested",
                                Description = "Patient",
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, thisSave.Id)
                            };
                            OrganizationService.Create(patSCEmail);
                        }

                        //Check for just changed values (Patient SC Team):
                        var isPatSCChanged = thisSave.cvt_ApprovalStatusPatientSC?.Value;
                        Logger.WriteDebugMessage("isPatSCChanged=" + isPatSCChanged);
                        // Check for SC Signee lookup update in the save object and if CoS is pending, then send new CoS Email
                        if (isPatSCChanged != null && isPatSCChanged == (int)cvt_facilityapprovalstatus.Approve && patCOS == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY)
                        {//Send email to PAT COS
                            Email patCOSEmail = new Email()
                            {
                                Subject = "Chief of Staff Approval Requested",
                                Description = "Patient",
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, thisSave.Id)
                            };
                            OrganizationService.Create(patCOSEmail);
                        }


                        //Check for just changed values (Provider SC Team):
                        var isProSCChanged = thisSave.cvt_ApprovalStatusProviderSC?.Value;
                        Logger.WriteDebugMessage("isProSCChanged=" + isProSCChanged);
                        if (isProSCChanged != null && isProSCChanged == (int)cvt_facilityapprovalstatus.Approve && proCOS == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY)
                        {//Send email to PRO COS
                            Email proCOSEmail = new Email()
                            {
                                Subject = "Chief of Staff Approval Requested",
                                Description = "Provider",
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, thisSave.Id)
                            };
                            OrganizationService.Create(proCOSEmail);
                        }

                        //Check for just changed values:
                        var isHubDirectorChanged = thisSave.cvt_ApprovalStatusHubDirector?.Value;
                        Logger.WriteDebugMessage("isHubDirectorChanged=" + isHubDirectorChanged);
                        if (isHubDirectorChanged != null && isHubDirectorChanged == (int)cvt_facilityapprovalstatus.Approve && (proCOS == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY || patCOS == (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY))
                        {//Send email to PRO and PAT COS
                            Email COSEmail = new Email()
                            {
                                Subject = "Chief of Staff Approval Requested",
                                Description = "Hub",
                                RegardingObjectId = new EntityReference(cvt_facilityapproval.EntityLogicalName, thisSave.Id)
                            };
                            OrganizationService.Create(COSEmail);
                        }
                    }
                    //Update the status of this record to Pending
                    else if (facilityApprovalRecord.statuscode.Value != (int)cvt_facilityapproval_statuscode.Pending && allApproved == false && anyDenied == false)
                    {
                        Logger.WriteDebugMessage("allApproved = false and anyDenied = false, status is not pending, and should be changed to pending.");
                        UpdateFacilityApprovalStatus(facilityApprovalRecord.Id, (int)cvt_facilityapproval_statuscode.Pending);
                        //entry point to Build Service at 'EntryFromFacilityApproval' for PENDING FA
                        Logger.WriteDebugMessage("Updating Service - FA: " + facilityApprovalRecord.cvt_name + ". Status of FA has changed to 'Pending'.");
                        CvtHelper.EntryFromFacilityApproval(facilityApprovalRecord, Logger, OrganizationService);
                    }

                    if (!isActive)
                    {
                        //entry point to Build Service at 'EntryFromFacilityApproval' for PENDING FA
                        Logger.WriteDebugMessage("Updating Service - FA: " + facilityApprovalRecord.cvt_name + ". State of FA is Inactive.");
                        CvtHelper.EntryFromFacilityApproval(facilityApprovalRecord, Logger, OrganizationService);
                    }
                }

            }
        }

        internal static string GetRecordLink(EntityReference record, IOrganizationService OrganizationService, string clickHereText = "")
        {
            var etc = CvtHelper.GetEntityTypeCode(OrganizationService, record.LogicalName);
            string servernameAndOrgname = CvtHelper.getServerURL(OrganizationService);
            string url = servernameAndOrgname + "/userDefined/edit.aspx?etc=" + etc + "&id=" + record.Id;
            return String.Format("<a href=\"{0}\">{1}</a>", url, !string.IsNullOrEmpty(clickHereText) ? clickHereText : url);
        }

        internal Boolean CheckApprovedStatus(int? intApprovalStatus, Boolean anyDenied, Boolean allApproved, out Boolean anyDeniedOut)
        {
            switch (intApprovalStatus)
            {
                case (int)cvt_facilityapprovalstatus.Deny:
                    anyDenied = true;
                    break;
                case (int)cvt_facilityapprovalstatus.Approve:
                    allApproved = true;
                    break;
                case (int)cvt_facilityapprovalstatus.ClickheretoAPPROVEorDENY:
                    allApproved = false;
                    break;
                default:
                    allApproved = false;
                    break;
            }
            anyDeniedOut = anyDenied;
            return allApproved;
        }

        internal Boolean CheckRecordStatus(int? statecode)
        {
            bool isActive=true;

            if (statecode != null)
            {
                switch (statecode)
                {
                    case (int)cvt_facilityapprovalState.Inactive:
                        isActive = false;
                        break;
                    case (int)cvt_facilityapprovalState.Active:
                        isActive = true;
                        break;
                }
            }
            else
            {
                isActive = false;
            }


            return isActive;
        }

        internal void UpdateFacilityApprovalStatus(Guid facilityApprovalID, int newStatus)
        {
            //Change State of FA
            SetStateRequest changeFA = new SetStateRequest()
            {
                EntityMoniker = new EntityReference(cvt_facilityapproval.EntityLogicalName, facilityApprovalID),
                State = new OptionSetValue((int)cvt_facilityapprovalState.Active),
                Status = new OptionSetValue(newStatus)
            };

            OrganizationService.Execute(changeFA);
        }
    }
}